/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.components.NewTextureButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public abstract class ArmorStandWidgetsScreen
extends AbstractArmorStandScreen {
    private final List<PositionScreenWidget> widgets;
    @Nullable
    private PositionScreenWidget activeWidget;

    public ArmorStandWidgetsScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.widgets = ImmutableList.copyOf(this.buildWidgets(holder.getArmorStand()));
    }

    protected abstract List<PositionScreenWidget> buildWidgets(ArmorStand var1);

    private Collection<PositionScreenWidget> getActivePositionComponentWidgets() {
        if (this.activeWidget != null) {
            ArrayList activeWidgets = Lists.newArrayList((Object[])new PositionScreenWidget[]{this.activeWidget});
            for (PositionScreenWidget widget : this.widgets) {
                if (!widget.alwaysVisible(this.activeWidget)) continue;
                activeWidgets.add(widget);
            }
            return activeWidgets;
        }
        return this.widgets;
    }

    protected void setActiveWidget(PositionScreenWidget widget) {
        if (this.activeWidget == widget) {
            this.toggleMenuRendering(false);
            this.activeWidget = null;
        } else {
            this.activeWidget = widget;
            this.toggleMenuRendering(true);
        }
    }

    @Override
    protected boolean renderInventoryEntity() {
        return false;
    }

    @Override
    protected boolean disableMenuRendering() {
        return this.activeWidget != null;
    }

    @Override
    protected void toggleMenuRendering(boolean disableMenuRendering) {
        super.toggleMenuRendering(disableMenuRendering);
        for (PositionScreenWidget widget : this.widgets) {
            widget.setVisible(!disableMenuRendering || widget.alwaysVisible(this.activeWidget));
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.getActivePositionComponentWidgets().forEach(PositionScreenWidget::tick);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this);
        int startY = (188 - this.widgets.size() * 22 - (this.widgets.size() - 1) * 7) / 2;
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).init(this.leftPos + 8, this.topPos + startY + this.getWidgetRenderOffset() + i * 29);
        }
    }

    protected int getWidgetRenderOffset() {
        return 7;
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        for (PositionScreenWidget widget : this.getActivePositionComponentWidgets()) {
            widget.render(poseStack, mouseX, mouseY, partialTick);
        }
    }

    protected static interface PositionScreenWidget {
        public void tick();

        public void init(int var1, int var2);

        public void setVisible(boolean var1);

        public void render(PoseStack var1, int var2, int var3, float var4);

        public boolean alwaysVisible(@Nullable PositionScreenWidget var1);
    }

    protected abstract class AbstractPositionScreenWidget
    implements PositionScreenWidget {
        protected final Component title;
        protected int posX;
        protected int posY;
        protected List<AbstractWidget> children;

        protected AbstractPositionScreenWidget(Component title) {
            this.title = title;
        }

        @Override
        public void tick() {
        }

        @Override
        public void init(int posX, int posY) {
            this.posX = posX;
            this.posY = posY;
            this.children = Lists.newArrayList();
        }

        @Override
        public final void setVisible(boolean visible) {
            for (AbstractWidget widget : this.children) {
                widget.f_93624_ = visible;
            }
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (ArmorStandWidgetsScreen.this.disableMenuRendering()) {
                NewTextureButton.drawCenteredString(poseStack, ArmorStandWidgetsScreen.this.f_96547_, this.title, this.posX + 36, this.posY + 6, -1, true);
            } else {
                NewTextureButton.drawCenteredString(poseStack, ArmorStandWidgetsScreen.this.f_96547_, this.title, this.posX + 36, this.posY + 6, 0x404040, false);
            }
        }

        @Override
        public boolean alwaysVisible(@Nullable PositionScreenWidget activeWidget) {
            return activeWidget == this;
        }
    }
}

